//
//  MCPGDatabase+Conveniences.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 22/11/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import "MCPGDatabase.h"


@interface MCPGDatabase (Conveniences)

- (NSNumber*)databaseSize;
- (NSString*)databaseSizeAsString;

- (NSNumber*)sizeOfTable:(NSString *)aTableName;
- (NSString*)sizeOfTableAsString:(NSString *)aTableName;
- (NSNumber*)rowCountForTable: (NSString*)aTableName;

- (BOOL)doesDatabaseExistNamed: (NSString*)aDatabaseName;
- (BOOL)doesTableExistNamed: (NSString*)aTableName;

- (NSNumber*)schemaNumber;

// methods to help determine if a database is hosted locally or remotely
-(BOOL)isRemote;	// remotely hosted (so shared)?
-(BOOL)isPersonal;	// local personal or local shared? 

// These call use the concept of making a table in the database to mark operations that can leave the database invalid.
//  The unmark call removes the table and the is call checks for its existence
- (BOOL)markAsOperationInProgress;
- (BOOL)unmarkAsOperationInProgress;
- (BOOL)isOperationInProgress;

@end
